/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.TickingData;

public class NewTickingData {
    private static final Object2ObjectMap<UUID, String> CACHED_NAMES = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<UUID, String> CACHED_FILE_NAMES = new Object2ObjectOpenHashMap();
    private static final NewTickingData REFRESH_DATA = new NewTickingData(TickingType.REFRESH);
    private static final NewTickingData DECAY_DATA = new NewTickingData(TickingType.DECAY);
    private final String prefix;
    private final TickingType type;

    public static NewTickingData getRefreshData() {
        return REFRESH_DATA;
    }

    public static NewTickingData getDecayData() {
        return DECAY_DATA;
    }

    public void migrateOldData(MinecraftServer server, TickingData oldData) {
        long currentGameTime = server.method_27728().method_27859().method_188();
        for (Object2IntMap.Entry entry : oldData.getTickMap().object2IntEntrySet()) {
            UUID id = (UUID)entry.getKey();
            long completesAt = currentGameTime;
            int oldValue = entry.getIntValue();
            if (oldValue > 0) {
                completesAt += (long)oldValue;
            }
            Section section = this.getSection(server, id);
            try {
                section.setCompletesAt(id, completesAt);
            }
            catch (SectionException e) {
                LootrAPI.LOG.error("Unable to migrate {} ticking data for id {}: section mismatch, expected {}", (Object)this.type.getPrefix(), (Object)id, (Object)section.cachedName);
            }
        }
        oldData.clear();
    }

    protected NewTickingData(TickingType type) {
        this.type = type;
        this.prefix = "lootr/ticking/" + type.getPrefix() + "/";
    }

    public void setCompletesIn(MinecraftServer server, UUID id, long tickTime) {
        Section section = this.getSection(server, id);
        try {
            section.setCompletesAt(id, server.method_27728().method_27859().method_188() + tickTime);
        }
        catch (SectionException e) {
            LootrAPI.LOG.error("Unable to set {} ticking data for id {}: section mismatch, expected {}", (Object)this.type.getPrefix(), (Object)id, (Object)section.cachedName);
        }
    }

    public void clearTicking(MinecraftServer server, UUID id) {
        Section section = this.getSection(server, id);
        try {
            section.setCompletesAt(id, -1L);
        }
        catch (SectionException e) {
            LootrAPI.LOG.error("Unable to clear {} ticking data for id {}: section mismatch, expected {}", (Object)this.type.getPrefix(), (Object)id, (Object)section.cachedName);
        }
    }

    public long howLongUntilComplete(MinecraftServer server, UUID id) {
        Section section = this.getSection(server, id);
        try {
            long completesAt = section.completesAt(id);
            if (completesAt == -1L) {
                return -1L;
            }
            long currentTime = server.method_27728().method_27859().method_188();
            return Math.max(0L, completesAt - currentTime);
        }
        catch (SectionException e) {
            LootrAPI.LOG.error("Unable to get {} ticking data for id {}: section mismatch, expected {}", (Object)this.type.getPrefix(), (Object)id, (Object)section.cachedName);
            return -1L;
        }
    }

    private static String getCached(UUID id) {
        return (String)CACHED_NAMES.computeIfAbsent((Object)id, UUID::toString);
    }

    private static String getBaseFileName(UUID id) {
        return (String)CACHED_FILE_NAMES.computeIfAbsent((Object)id, uuid -> {
            String name = NewTickingData.getCached(uuid);
            return name.substring(0, 2);
        });
    }

    private String getFileName(UUID id) {
        return this.prefix + NewTickingData.getBaseFileName(id);
    }

    private Section getSection(MinecraftServer server, UUID id) {
        class_3218 level = server.method_30002();
        class_26 dataStorage = level.method_17983();
        return (Section)dataStorage.method_17924(new class_10741(this.getFileName(id), () -> new Section(NewTickingData.getBaseFileName(id)), Section.CODEC.apply(NewTickingData.getBaseFileName(id)), null));
    }

    protected static class Section
    extends class_18 {
        public static final Function<String, Codec<Section>> CODEC = name -> TickEntry.CODEC.listOf().xmap(data -> new Section((String)name, (List<TickEntry>)data), o -> o.getTickMap().object2LongEntrySet().stream().map(e -> new TickEntry((UUID)e.getKey(), e.getLongValue())).toList());
        private final Object2LongMap<UUID> tickMap = new Object2LongOpenHashMap();
        private final String cachedName;

        public Section(String cachedName) {
            this.tickMap.defaultReturnValue(-1L);
            this.cachedName = cachedName;
        }

        private Section(String cachedName, List<TickEntry> entries) {
            this(cachedName);
            for (TickEntry entry : entries) {
                this.tickMap.put((Object)entry.id(), entry.value());
            }
        }

        private boolean excludes(UUID id) {
            return !this.cachedName.equals(NewTickingData.getBaseFileName(id));
        }

        public boolean completed(MinecraftServer server, UUID id) throws SectionException {
            if (this.excludes(id)) {
                throw new SectionException();
            }
            long completesAt = this.completesAt(id);
            if (completesAt == -1L) {
                return false;
            }
            return server.method_27728().method_27859().method_188() >= completesAt;
        }

        public long completesAt(UUID id) throws SectionException {
            if (this.excludes(id)) {
                throw new SectionException();
            }
            return this.tickMap.getLong((Object)id);
        }

        public void setCompletesAt(UUID id, long tickTime) throws SectionException {
            if (this.excludes(id)) {
                throw new SectionException();
            }
            this.tickMap.put((Object)id, tickTime);
            this.method_80();
        }

        private Object2LongMap<UUID> getTickMap() {
            return this.tickMap;
        }

        private record TickEntry(UUID id, long value) {
            public static final Codec<TickEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("id").forGetter(TickEntry::id), (App)Codec.LONG.fieldOf("value").forGetter(TickEntry::value)).apply((Applicative)instance, TickEntry::new));
        }
    }

    public static class SectionException
    extends Exception {
    }

    public static enum TickingType {
        DECAY("decay"),
        REFRESH("refresh");

        private final String prefix;

        private TickingType(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

